<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobExperience extends Model 
{

    protected $table = 'job_experiences';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('job_id', 'experience_level_id');

    public function job()
    {
        return $this->belongsTo('App\Models\Job', 'job_id');
    }

    public function experienceLevel()
    {
        return $this->belongsTo('App\Models\ExperienceLevel', 'experience_level_id');
    }

}